/*
 * Decompiled with CFR 0.152.
 */
package dev.engine_room.flywheel.backend;

import dev.engine_room.flywheel.api.material.CutoutShader;
import dev.engine_room.flywheel.api.material.FogShader;
import dev.engine_room.flywheel.backend.compile.PipelineCompiler;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import it.unimi.dsi.fastutil.objects.ObjectList;
import java.util.List;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Unmodifiable;

public final class MaterialShaderIndices {
    private static final Index fogSources = new Index();
    private static final Index cutoutSources = new Index();

    private MaterialShaderIndices() {
    }

    public static Index fogSources() {
        return fogSources;
    }

    public static Index cutoutSources() {
        return cutoutSources;
    }

    public static int fogIndex(FogShader fogShader) {
        return MaterialShaderIndices.fogSources().index(fogShader.source());
    }

    public static int cutoutIndex(CutoutShader cutoutShader) {
        return MaterialShaderIndices.cutoutSources().index(cutoutShader.source());
    }

    public static class Index {
        private final Object2IntMap<class_2960> sources2Index = new Object2IntOpenHashMap();
        private final ObjectList<class_2960> sources;

        private Index() {
            this.sources2Index.defaultReturnValue(-1);
            this.sources = new ObjectArrayList();
        }

        public class_2960 get(int index) {
            return (class_2960)this.sources.get(index);
        }

        public int index(class_2960 source) {
            int out = this.sources2Index.getInt((Object)source);
            if (out == -1) {
                this.add(source);
                PipelineCompiler.deleteAll();
                return this.sources2Index.getInt((Object)source);
            }
            return out;
        }

        public @Unmodifiable List<class_2960> all() {
            return this.sources;
        }

        private void add(class_2960 source) {
            if (this.sources2Index.putIfAbsent((Object)source, this.sources.size()) == -1) {
                this.sources.add((Object)source);
            }
        }
    }
}

